<!-- 
    ===========================
    Theme Author: Evan Ahmed EMon
    Theme Designed By: CJ7 by TWG 
    Contact WhatsApp: +8801864614704
    ===========================
-->

<?php include 'header.php'; ?>
<div class="container">
    <?php if (isset($success)) : ?>
        <div class="alert alert-success"><?= $successText ?></div>
    <?php endif; ?>
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-body">
                    <form action="<?= $cyberkuttyadmin ?>/account" method="post">
                        <!-- Username -->
                        <div class="form-group">
                            <label for="username" class="control-label">Username</label>
                            <input type="text" class="form-control" value="<?=$admin["username"]?>" name="username" readonly>
                        </div>

                        <!-- Email -->
                        <div class="form-group">
                            <label for="admin_email" class="control-label">Email</label>
                            <input type="text" class="form-control" value="<?=$admin["admin_email"]?>" name="admin_email" readonly>
                        </div>

                        <!-- Current Password -->
                        <div class="form-group">
                            <label for="current_password" class="control-label">Current Password (required)</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="current_password" required>
                                <span class="input-group-addon btn-secondary" onclick="showPassword(this)">
                                    <i class="bi bi-eye"></i>
                                </span>
                            </div>
                        </div>

                        <!-- New Password -->
                        <div class="form-group">
                            <label for="password" class="control-label">New Password </label>  <small>( Password must be at least 8 characters long and include one letter, one number, and one special character. )</small>
                             <div class="input-group">
                                <input type="password" class="form-control" 
                                       name="password" 
                                       pattern="^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$!%*#?&]{8,}$" 
                                       title="Password must be at least 8 characters long and include one letter, one number, and one special character." 
                                       required>
                                <span class="input-group-addon btn-secondary" onclick="showPassword(this)">
                                    <i class="bi bi-eye"></i>
                                </span>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="form-group">
                            <label for="confirm_password" class="control-label">Confirm New Password</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="confirm_password" required>
                                <span class="input-group-addon btn-secondary" onclick="showPassword(this)">
                                    <i class="bi bi-eye"></i>
                                </span>
                            </div>
                        </div>

                        <!-- CSRF Token -->
                        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8'); ?>">

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary">Change Password</button>
                    </form>

                    <!-- Two-factor Authentication -->
                    <form method="POST" style="margin-top: 20px;">
                        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                        <input type="hidden" name="update_two_factor" value="1">

                        <label for="two_factor">Two-Factor Authentication</label>
                        <select class="form-control" name="two_factor">
                            <option value="1" <?= $admin["two_factor"] == 1 ? "selected" : "" ?>>Enabled</option>
                            <option value="0" <?= $admin["two_factor"] == 0 ? "selected" : "" ?>>Disabled</option>
                        </select>
                        <hr>
                        <button type="submit" class="btn btn-primary">Save Two-Factor Setting</button>
                    </form>

                    <!-- Toggle Password Visibility Script -->
                    <script>
                        function showPassword(element) {
                            const input = element.parentNode.querySelector('input');
                            const icon = element.querySelector('i');
                            if (input.type === 'password') {
                                input.type = 'text';
                                icon.classList.remove('bi-eye');
                                icon.classList.add('bi-eye-slash');
                            } else {
                                input.type = 'password';
                                icon.classList.remove('bi-eye-slash');
                                icon.classList.add('bi-eye');
                            }
                        }

                        // Password match validation
                        document.querySelector('form').addEventListener('submit', function(event) {
                            const password = document.querySelector('input[name="password"]').value;
                            const confirmPassword = document.querySelector('input[name="confirm_password"]').value;

                            if (password !== confirmPassword) {
                                alert('Passwords do not match.');
                                event.preventDefault();
                            }
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>