<?php include 'header.php'; ?>

<?php
// Function to get location from IP address using ip-api API
function get_ip_location($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    
    // Check if the request was successful and return the city name
    if ($data && $data['status'] == 'success') {
        return $data['city']; // You can also return $data['country'] or $data['regionName']
    } else {
        return 'Unknown'; // Return 'Unknown' if location is not found
    }
}
?>

<div class="container-fluid">
    <ul class="nav nav-tabs">
        <li class="pull-right custom-search">
            <form class="form-inline" action="<?= site_url("$cyberkuttyadmin/logs") ?>" method="get">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" value="<?= $search_word ?>" placeholder="Search">
                    <span class="input-group-btn search-select-wrap">
                        <select class="form-control search-select" name="search_type">
                            <option value="username" <?php if ($search_where == "username") echo 'selected'; ?>>Username</option>
                            <option value="action" <?php if ($search_where == "action") echo 'selected'; ?>>Action</option>
                        </select>
                        <button type="submit" class="btn btn-default">
                            <span class="fa fa-search" aria-hidden="true"></span>
                        </button>
                    </span>
                </div>
            </form>
        </li>
    </ul>

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">Registered System Logs</div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="checkAll-th">
                                        <div class="checkAll-holder">
                                            <input type="checkbox" id="checkAll">
                                            <input type="hidden" id="checkAllText" value="order">
                                        </div>
                                        <div class="action-block">
                                            <ul class="action-list" style="margin:5px 0 0 0!important">
                                                <li><span class="countlogs"></span> Selected Logs</li>
                                                <li>
                                                    <div class="dropdown">
                                                        <button type="button" class="btn btn-default btn-xs dropdown-toggle btn-xs-caret" data-toggle="dropdown"> Batch Operations <span class="caret"></span></button>
                                                        <ul class="dropdown-menu">
                                                            <li>
                                                                <a class="bulkorder" data-type="delete">Delete</a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </th>
                                    <th>Admin</th>
                                    <th>Details</th>
                                    <th>IP Address</th>
                                    <th>History</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <form id="changebulkForm" action="<?= site_url("$cyberkuttyadmin/adminlog/multi-action") ?>" method="post">
                                <tbody>
                                    <?php if (!$logs): ?>
                                        <tr>
                                            <td><center>No logs found</center></td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php foreach ($logs as $log): ?>
                                        <tr>
                                            <td><input type="checkbox" class="selectOrder" name="log[<?= $log["id"] ?>]" value="1" style="border:1px solid #fff"></td>
                                            <td><?= $admin["username"] ?></td>
                                            <td><?= $log["action"] ?></td>
                                            <td>
                                                <?php
                                                $city = get_ip_location($log["report_ip"]);
                                                echo '<i class="fa-solid fa-location-crosshairs"></i> ' . $city;
                                                ?>
                                            </td>
                                            <td><?= $log["report_date"] ?></td>
                                            <td>
                                                <form action="<?= site_url("$cyberkuttyadmin/adminlog/delete/" . $log['id']); ?>" method="POST" style="display:inline;">
                                                    <button type="submit" class="btn btn-danger btn-xs" style="font-size: 12px; padding: 5px 10px;">
                                                        <i class="fa fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <input type="hidden" name="bulkStatus" id="bulkStatus" value="0">
                            </form>
                        </table>
                    </div>
                </div>
            </div>

            <?php if ($paginationArr["count"] > 1): ?>
                <div class="row">
                    <div class="col-sm-8">
                        <nav>
                            <ul class="pagination">
                                <?php if ($paginationArr["current"] != 1): ?>
                                    <li class="prev"><a href="<?= site_url("$cyberkuttyadmin/logs/1/" . $search_link) ?>">&laquo;</a></li>
                                    <li class="prev"><a href="<?= site_url("$cyberkuttyadmin/logs/" . $paginationArr["previous"] . "/" . $search_link) ?>">&lsaquo;</a></li>
                                <?php endif; ?>
                                <?php
                                for ($page = 1; $page <= $pageCount; $page++):
                                    if ($page >= ($paginationArr['current'] - 9) and $page <= ($paginationArr['current'] + 9)):
                                        ?>
                                        <li class="<?= $page == $paginationArr["current"] ? "active" : ""; ?>"><a href="<?= site_url("$cyberkuttyadmin/logs/" . $page . "/" . $status . $search_link) ?>"><?= $page ?></a></li>
                                    <?php endif; endfor;
                                if ($paginationArr["current"] != $paginationArr["count"]):
                                    ?>
                                    <li class="next"><a href="<?= site_url("$cyberkuttyadmin/logs/" . $paginationArr["next"] . "/" . $search_link) ?>" data-page="1">&rsaquo;</a></li>
                                    <li class="next"><a href="<?= site_url("$cyberkuttyadmin/logs/" . $paginationArr["count"] . "/" . $search_link) ?>" data-page="1">&raquo;</a></li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="modal modal-center fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
    <div class="modal-dialog modal-dialog-center" role="document">
        <div class="modal-content">
            <div class="modal-body text-center">
                <h4>Are you sure you want to take action?</h4>
                <div align="center">
                    <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
