<style>
  /* Panel styling */
  .panel {
    border: 1px solid #ddd;
    border-radius: 4px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
  }

  .panel-body {
    padding: 20px;
    background-color: #f9f9f9;
  }

  /* Form styling */
  .form-group label {
    font-weight: bold;
    margin-bottom: 5px;
    display: block;
  }

.form-control {
    border: 1px solid #ccc;
    border-radius: 4px;
    padding: 6px; /* ফিল্ডের ভেতরের স্পেসিং */
    font-size: 15px; /* লেখার সাইজ ঠিক করা */
    line-height: 1.5; /* লাইনের উচ্চতা ঠিক করা */
    height: auto; /* অটো উচ্চতা */
}

 

 

  /* Responsive adjustments */
  @media (max-width: 768px) {
    .col-md-8 {
      width: 100%;
    }
  }

  /* Toggle visibility */
  #google_settings {
    margin-top: 20px;
  }
</style>

<div class="col-md-8">
  <?php $google_login = json_decode($settings["google_login"], true); ?>

  <div class="panel panel-default">
    <div class="panel-body">
        
        <?php
if (route(3) == "ip") {
    $ipType = ($_POST['ip_type'] == 1 || $_POST['ip_type'] == 2) ? $_POST['ip_type'] : null;
    $ip = filter_var($_POST['ip'], FILTER_SANITIZE_STRING);
    if (!empty($ipType)) {
        $update = $conn->prepare("UPDATE admins SET ip_type = :ipType, ip = :ip");
        $update->execute(array("ipType" => $ipType, "ip" => $ip));
    } else {
        echo "Please provide a valid IP type.";
    }
}
$adminQuery = $conn->prepare("SELECT * FROM admins");
$adminQuery->execute();
$admin = $adminQuery->fetch(PDO::FETCH_ASSOC);
$inputValue = (isset($_POST['ip']) && route(3) == "ip") ? htmlspecialchars($_POST['ip']) : obfuscate_provider_key($admin["ip"]);
?>
      <form id="ipForm" action="/<?= $cyberkuttyadmin?>/settings/modules/ip" method="post" enctype="multipart/form-data">
        <div class="form-group">
          <label for="" class="control-label">IP Security</label>
          <select class="form-control" name="ip_type">
            <option value="1" <?= $admin["ip_type"] == 1 ? "selected" : null; ?>>Disabled</option>
            <option value="2" <?= $admin["ip_type"] == 2 ? "selected" : null; ?>>Enabled</option>
          </select>
        </div>
        <div class="form-group">
          <label for="" class="control-label">Your IPv6 Address</label>
          <input type="text" class="form-control" name="ip" value="<?= $inputValue ?>">
        </div>
        <button type="submit" class="btn btn-primary">Save Changes</button>
      </form> 
     

        
      <form action="" method="post" enctype="multipart/form-data">
        <!-- Affiliate System -->
        <div class="form-group">
          <label for="affiliates_status">Affiliate System</label>
          <select class="form-control" name="affiliates_status">
            <option value="1" <?= $settings["referral_status"] == 1 ? "selected" : ""; ?>>Disabled</option>
            <option value="2" <?= $settings["referral_status"] == 2 ? "selected" : ""; ?>>Enabled</option>
          </select>
        </div>

        <div class="form-group">
          <label for="commission">Commission Rate (%)</label>
          <input type="number" class="form-control" name="commision" value="<?= $settings["referral_commision"]; ?>" placeholder="Enter commission rate">
        </div>

        <div class="form-group">
          <label for="minimum_payout">Minimum Payout</label>
          <input type="number" class="form-control" name="minimum" value="<?= $settings["referral_payout"]; ?>" placeholder="Enter minimum payout">
        </div>

        <hr>

        <!-- Child Panel Selling -->
        <div class="form-group">
          <label for="childpanel_selling">Child Panel Selling</label>
          <select class="form-control" name="selling">
            <option value="1" <?= $settings["childpanel_selling"] == 1 ? "selected" : ""; ?>>Disabled</option>
            <option value="2" <?= $settings["childpanel_selling"] == 2 ? "selected" : ""; ?>>Enabled</option>
          </select>
        </div>

        <div class="form-group">
          <label for="childpanel_price">Child Panel Price</label>
          <input type="text" class="form-control" name="price" value="<?= $settings["childpanel_price"]; ?>" placeholder="Enter panel price">
        </div>

        <hr>

        <!-- Free Balance -->
        <div class="form-group">
          <label for="freebalance">Free Balance</label>
          <select class="form-control" name="freebalance">
            <option value="1" <?= $settings["freebalance"] == 1 ? "selected" : ""; ?>>Disabled</option>
            <option value="2" <?= $settings["freebalance"] == 2 ? "selected" : ""; ?>>Enabled</option>
          </select>
        </div>

        <div class="form-group">
          <label for="freeamount">Free Amount</label>
          <input type="text" class="form-control" name="freeamount" value="<?= $settings["freeamount"]; ?>" placeholder="Enter free amount">
        </div>

        <hr>

        <!-- Updates Logs -->
        <div class="form-group">
          <label for="updates_show">Updates Logs</label>
          <select class="form-control" name="updates_show">
            <option value="1" <?= $general["updates_show"] == 1 ? "selected" : ""; ?>>Disabled</option>
            <option value="2" <?= $general["updates_show"] == 2 ? "selected" : ""; ?>>Enabled</option>
          </select>
        </div>

        <!-- Mass Order -->
        <div class="form-group">
          <label for="massorder">Mass Order</label>
          <select class="form-control" name="massorder">
            <option value="1" <?= $general["massorder"] == 1 ? "selected" : ""; ?>>Disabled</option>
            <option value="2" <?= $general["massorder"] == 2 ? "selected" : ""; ?>>Enabled</option>
          </select>
        </div>

        <hr>

        <!-- Google Login -->
        <div class="form-group">
          <label for="google_login">Google Login</label>
          <select class="form-control" name="google_login" id="google_login" onchange="toggleGoogleSettings()">
            <option value="1" <?= ($google_login["status"] == 1) ? "selected" : ""; ?>>Enable</option>
            <option value="0" <?= ($google_login["status"] == 0) ? "selected" : ""; ?>>Disable</option>
          </select>
        </div>

        <!-- Google Settings -->
        <div id="google_settings" style="display: <?= ($google_login["status"] == 1) ? "block" : "none"; ?>;">
          <div class="form-group">
            <label for="google_client_id">Google Client ID</label>
            <input type="text" class="form-control" name="google_client_id" id="google_client_id" value="<?= htmlspecialchars($settings['google_client_id'] ?? ''); ?>" placeholder="Enter your Google Client ID">
          </div>

          <div class="form-group">
            <label for="google_client_secret">Google Client Secret</label>
            <input type="text" class="form-control" name="google_client_secret" id="google_client_secret" value="<?= htmlspecialchars($settings['google_client_secret'] ?? ''); ?>" placeholder="Enter your Google Client Secret">
          </div>
        </div>

        <div class="form-group text-left">
          <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  // Toggle visibility of Google Settings
  function toggleGoogleSettings() {
    const googleLoginSelect = document.getElementById("google_login");
    const googleSettingsDiv = document.getElementById("google_settings");

    googleSettingsDiv.style.display = (googleLoginSelect.value == "1") ? "block" : "none";
  }
</script>
