function category_detail() {
    const category_now = $("#neworder_category").val();
    $.ajax({
        url: '/ajax_data',
        type: 'POST',
        data: { action: 'services_list', category: category_now },
        success: function(response) {
            const json = JSON.parse(response);
            $("#neworder_services").html(json.services).trigger("change");
            service_detail();
        }
    });
}
function service_detail() {
    const service_now = $("#neworder_services").val();
    $.post('ajax_data', { action: 'service_detail', service: service_now }, function(data) {
        $("#charge_div").toggle(!data.empty);
        $("#neworder_fields").html(data.details);
        $("#charge").val(data.price);

        const dripfeed = $("#dripfeedcheckbox").prop('checked');
        $("#dripfeed-options").toggle(dripfeed);
        comment_charge();

        if (dripfeed) {
            dripfeed_charge();
        }

        $("#charge_div").toggle(!data.sub);
    }, 'json');
}
function comment_charge() {
    const service = $("#neworder_services").val();
    const comments = $("#neworder_comment").val();

    if (comments) {
        $.post('ajax_data', { action: 'service_price', service: service, comments: comments }, function(data) {
            $("#neworder_quantity").val(data.commentsCount);
            $("#charge").val(data.price);
        }, 'json');
    }
}
function dripfeed_charge() {
    const service = $("#neworder_services").val();
    const quantity = $("#neworder_quantity").val();
    const runs = $("#dripfeed-runs").val();
    const dripfeed = $("#dripfeedcheckbox").prop('checked') ? "var" : "bos";

    $.post('ajax_data', {
        action: 'service_detail',
        service: service,
        quantity: quantity,
        dripfeed: dripfeed,
        runs: runs
    }, function(data) {
        $("#charge").val(data.price);
    }, 'json');
}
function password_generator(len = 10) {
    const string = "abcdefghijklmnopqrstuvwxyz";
    const numeric = '0123456789';
    const punctuation = '!@#$%^&*()_+|}{[]:;?><,./-=';
    let password = "";
    while (password.length < len) {
        const hold = string.charAt(Math.floor(Math.random() * string.length));
        password += password.length % 2 === 0 ? hold.toUpperCase() : hold;
        password += numeric.charAt(Math.floor(Math.random() * numeric.length));
        password += punctuation.charAt(Math.floor(Math.random() * punctuation.length));
    }
    return password.split('').sort(() => 0.5 - Math.random()).join('').substr(0, len);
}
function funBroadcast() {
    $.ajax({
        url: "/broadcastdata/",
        type: 'GET',
        success: function(data) {
            data = JSON.parse(data);
            if (data.id !== "undefined") {
                var div = document.createElement("div");
                div.innerHTML = data.BROADCAST_D;
                swal({
                    title: data.BROADCAST_M,
                    content: div,
                    icon: data.BROADCAST_T,
                    allowOutsideClick: false,
                    button: {
                        text: 'Ok!',
                        closeModal: true
                    },
                    width: '350px'
                }).then((result) => {
                    funBroadcast();
                });
            }
        }
    });
}

$(document).ready(function() {
    funBroadcast();
});
const style = document.createElement('style');
style.innerHTML = `
    @media (max-width: 600px) {
        .swal-modal {
            width: 90% !important;
            max-width: 90% !important;
        }
    }
    @media (min-width: 601px) {
        .swal-modal {
            width: 350px !important;
            max-width: 90% !important;
        }
    }
     .swal-footer {
        display: flex;
        justify-content: center;
        padding: 10px; 
    }
    .swal-button {
        background-color: #db694d !important; 
        color: white !important;
    }
`;
document.head.appendChild(style);

$(document).ready(function() {
    category_detail();

    $("#neworder_category").change(function() {
        category_detail();
    });

    $("#neworder_services").change(function() {
        service_detail();
    });
    $(document).on('keyup', '#neworder_quantity', function() {
        const service = $("#neworder_services").val();
        const quantity = $(this).val();
        const runs = $("#dripfeed-runs").val();
        const dripfeed = $("#dripfeedcheckbox").prop('checked') ? "var" : "bos";

        $.post('ajax_data', {
            action: 'service_price',
            service: service,
            quantity: quantity,
            dripfeed: dripfeed,
            runs: runs
        }, function(data) {
            $("#charge").val(data.price);
            $("#dripfeed-totalquantity").val(data.totalQuantity);
        }, 'json');
    });
    $(document).on('keyup', '#dripfeed-runs', function() {
        const service = $("#neworder_services").val();
        const quantity = $("#neworder_quantity").val();
        const runs = $(this).val();
        const dripfeed = $("#dripfeedcheckbox").prop('checked') ? "var" : "bos";

        $.post('ajax_data', {
            action: 'service_price',
            service: service,
            quantity: quantity,
            dripfeed: dripfeed,
            runs: runs
        }, function(data) {
            $("#charge").val(data.price);
            $("#dripfeed-totalquantity").val(data.totalQuantity);
        }, 'json');
    });
    $(document).on('keyup', '#neworder_comment', function() {
        comment_charge();
    });
    $(document).on('change', '#dripfeedcheckbox', function() {
        const dripfeed = $(this).prop('checked');
        $("#dripfeed-options").toggleClass('hidden', !dripfeed);
        if (dripfeed) {
            dripfeed_charge();
        }
    });
   $(document).ready(function() {
    $(".currencies-item").click(function(){
        var key = $(this).attr("data-rate-key");
        var sym = $(this).attr("data-rate-symbol");
        
        $.ajax({
            url: '/account/change_currency',
            data: 'rate_key=' + key + '&sym=' + sym,
            type: 'POST',
            success: function(resp) {
                window.location.reload();
            }
        });
    });
});

    $("#randomize_password").click(function() {
        const pass = password_generator(15);
        $("#childpanel_admin_password, #childpanel_admin_confirm_password").val(pass);
    });

  
});
